/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

/*
 *  SATA Test
 *
 */

#include "stdio.h"
#include "ahci.h"
#include "sata.h"


UINT32 sata_test(void)
{
    UINT32 i;
	printf("\nAn External SATA Hard Drive is required for this test.\n");
	printf("The test Spins up, Writes to and then Reads from the SATA device and verifies the written data. \n\n");

	/* SATA initalization */
//	PWRDN = 0x00;  // Enables SATA clock receiver

	// Firmware HwInit Fields Configuration values.
	swCtrlFeatures.capSMPS=1;   // Input Pin exist for external activity detection presence.
	swCtrlFeatures.capSSS=1;    // Always set to 1 in order to avoid spin up when HBA is powered.
	swCtrlFeatures.piPi=1;      // Freon supports a single HBA Port. This should always requires to be set to 1.
	swCtrlFeatures.p0cmdEsp=0;  // The state of this bit is based on the support for eSATA. 
	swCtrlFeatures.p0cmdCpd=0;  // Detection of Bus Power Device is supported. -> Not used.
	swCtrlFeatures.p0cmdMpsp=0; // We have bonded out a pin (input) to detect a change on a switch or line.  -> Not used.
	swCtrlFeatures.p0cmdHpcp=0; // Since ESP is mutually exclusive with HPCP (as mentioned in spec) then HPCP should be set to 1.  -> Not used.

	if(chceckSysMemorySize())
		for(;;);	// If program stays here, need to fix alignment issue.

	// Clear all the memory structures created System Memory
	clearCmdList();		// Clear Cmd List
	clearCmdTables();	// Clear Cmd Tables
	clearRcvFis();		// Clear Receive FIS
	clearDmaBuffers();	// Clear all DMA Buffers

	// HBA Reset necessary to force the Device to re-negotiate speed.
	invokeHBAReset();	// Perform HBA Reset.

	/* Initialize SATA Controller */
	performFirmwareInit();
	/* Start the Disk Drive */
	printf("    Spin up SATA drive... \n");
	if(spinUpDeviceAndWaitForInitToComplete())
	{
	    printf("    Disk spin-up failed. \n\n");
		return 1;
	}
	else
		printf("    Disk spin-up success. \n\n");

    cfgDmaSetting();  // Configure Port DMA Control Register
    initIntAndClearFlags(); // Disable CCC, Initialize 1ms Time, Clear Int and Flags

	enableDisableInt(PORTint, ENABLE, 0xFFC000FF); // enableDisableInt(int type, intState,specificField)
    
	/* Fill write buffer */
	initMemory((UINT32 *)&prdTableDataBuff[0], (PRDLENGTH*DATABUFFERLEN/4), 0x10001000, 0x00020002);
	/* Invalidate read buffer */
	initMemory((UINT32 *)&prdTableDataBuff[1], (PRDLENGTH*DATABUFFERLEN/4), 0xDEADDEAD, 0x00000000);

	/* Perform Write to Hard disk */
    printf("    Writing to HDD... \n");
    performDmaWrite(0x10);   // 28-Bit LBA Address = 0x10
	/* Perform Read from Hard disk */
    printf("    Reading from HDD... \n");
    performDmaRead(0x10);    // 28-Bit LBA Address = 0x10

    /* Check data */
    printf("    Comparing Data... \n\n");
	for(i=0;i<(DATABUFFERLEN * PRDLENGTH);i++)
		if(prdTableDataBuff[0][0][i] != prdTableDataBuff[1][0][i])
		{
            printf("    DATA ERROR \n\n");
			return 1;
		}

	return 0;
}
